/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;
/*
 * Diese Datei ist Teil des CridManager Projektes.
 * www.sourceforge.net/projects/cridmanager
 * 
 * Das CridManager Projekt ist freigegeben unter
 * der Gnu Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
/**
 * Ein String, der EPG-Steuerzeichen enthalten darf. Der DvbString bietet eine interne Darstellung,
 * die die Steuerzeichen enhalten kann, und eine externe Darstellung, die zur Ansicht im Programm
 * geeignet ist.
 */
public class DvbString {

	// TODO (final) vollstndig implementieren mit Bercksichtigung der Codes
	private char coding = ' ';
	private String internalString;
	private String displayString;

	public DvbString(String s) {
		internalString = s;
		if (s.length() > 0 && s.charAt(0) < ' ') {
			coding = s.charAt(0);
			displayString = s.substring(1);
		} else
			displayString = internalString;
		displayString = displayString.replace('\n', '');
		displayString = displayString.replaceAll("[\\x01-\\x1f]", ""); //$NON-NLS-1$ //$NON-NLS-2$
		//  = 8Ahex
		displayString = displayString.replace('', '\n');
	}

	/**
	 * @return
	 */
	public String getStorageString() {
		return internalString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String s) {
		displayString = s;
		String tempstring = displayString.replace('\n', '');
		if (coding < ' ')
			internalString = coding + tempstring;
		else
			internalString = tempstring;
	}

	/**
	 * @return Das Feld coding.
	 */
	public int getCoding() {
		return coding;
	}
}